"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, device_ids: List, tracker_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists the latest device positions for requested devices.

    Args:
        device_ids(List): Devices whose position you want to retrieve.   For example, for two devices: device-ids=DeviceId1&device-ids=DeviceId2   .
        tracker_name(str): The tracker resource retrieving the device position.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.get_device_position.batch(
                ctx, device_ids=value, tracker_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.get_device_position.batch device_ids=value, tracker_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="batch_get_device_position",
        op_kwargs={"DeviceIds": device_ids, "TrackerName": tracker_name},
    )
