"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, collection_name: str, geofence_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the geofence details from a geofence collection.

    Args:
        collection_name(str): The geofence collection storing the target geofence.
        geofence_id(str): The geofence you're retrieving details for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.geofence.init.get(
                ctx, collection_name=value, geofence_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.geofence.init.get collection_name=value, geofence_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="get_geofence",
        op_kwargs={"CollectionName": collection_name, "GeofenceId": geofence_id},
    )


async def list_all(hub, ctx, collection_name: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists geofences stored in a given geofence collection.

    Args:
        collection_name(str): The name of the geofence collection storing the list of geofences.
        next_token(str, optional): The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.  Default value: null . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.geofence.init.list_all(ctx, collection_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.geofence.init.list_all collection_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="list_geofences",
        op_kwargs={"CollectionName": collection_name, "NextToken": next_token},
    )


async def put(hub, ctx, collection_name: str, geofence_id: str, geometry: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.

    Args:
        collection_name(str): The geofence collection to store the geofence in.
        geofence_id(str): An identifier for the geofence. For example, ExampleGeofence-1.
        geometry(Dict): Contains the polygon details to specify the position of the geofence.  Each geofence polygon can have a maximum of 1,000 vertices. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.geofence.init.put(
                ctx, collection_name=value, geofence_id=value, geometry=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.geofence.init.put collection_name=value, geofence_id=value, geometry=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="put_geofence",
        op_kwargs={
            "CollectionName": collection_name,
            "GeofenceId": geofence_id,
            "Geometry": geometry,
        },
    )
