"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    collection_name: str,
    pricing_plan: str,
    description: str = None,
    kms_key_id: str = None,
    pricing_plan_data_source: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a geofence collection, which manages and stores geofences.

    Args:
        collection_name(str): A custom name for the geofence collection. Requirements:   Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).    Must be a unique geofence collection name.   No spaces allowed. For example, ExampleGeofenceCollection.  .
        description(str, optional): An optional description for the geofence collection. Defaults to None.
        kms_key_id(str, optional): A key identifier for an AWS KMS customer managed key. Enter a key ID, key ARN, alias name, or alias ARN. . Defaults to None.
        pricing_plan(str): Specifies the pricing plan for the geofence collection. For additional details and restrictions on each pricing plan option, see the Amazon Location Service pricing page.
        pricing_plan_data_source(str, optional): Specifies the data provider for the geofence collection.   Required value for the following pricing plans: MobileAssetTracking | MobileAssetManagement    For more information about Data Providers, and Pricing plans, see the Amazon Location Service product page.  Amazon Location Service only uses PricingPlanDataSource to calculate billing for your geofence collection. Your data won't be shared with the data provider, and will remain in your AWS account or Region unless you move it.  Valid Values: Esri | Here . Defaults to None.
        tags(Dict, optional): Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them. Format: "key" : "value"  Restrictions:   Maximum 50 tags per resource   Each resource tag must be unique with a maximum of one value.   Maximum key length: 128 Unicode characters in UTF-8   Maximum value length: 256 Unicode characters in UTF-8   Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.geofence.collection.create(
                ctx, collection_name=value, pricing_plan=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.geofence.collection.create collection_name=value, pricing_plan=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="create_geofence_collection",
        op_kwargs={
            "CollectionName": collection_name,
            "Description": description,
            "KmsKeyId": kms_key_id,
            "PricingPlan": pricing_plan,
            "PricingPlanDataSource": pricing_plan_data_source,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, collection_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a geofence collection from your AWS account.  This operation deletes the resource permanently. If the geofence collection is the target of a tracker resource, the devices will no longer be monitored.

    Args:
        collection_name(str): The name of the geofence collection to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.geofence.collection.delete(ctx, collection_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.geofence.collection.delete collection_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="delete_geofence_collection",
        op_kwargs={"CollectionName": collection_name},
    )


async def describe(hub, ctx, collection_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the geofence collection details.

    Args:
        collection_name(str): The name of the geofence collection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.geofence.collection.describe(
                ctx, collection_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.geofence.collection.describe collection_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="describe_geofence_collection",
        op_kwargs={"CollectionName": collection_name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists geofence collections in your AWS account.

    Args:
        max_results(int, optional): An optional limit for the number of resources returned in a single call.  Default value: 100 . Defaults to None.
        next_token(str, optional): The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.  Default value: null . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.geofence.collection.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.geofence.collection.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="list_geofence_collections",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    collection_name: str,
    description: str = None,
    pricing_plan: str = None,
    pricing_plan_data_source: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified properties of a given geofence collection.

    Args:
        collection_name(str): The name of the geofence collection to update.
        description(str, optional): Updates the description for the geofence collection. Defaults to None.
        pricing_plan(str, optional): Updates the pricing plan for the geofence collection. For more information about each pricing plan option restrictions, see Amazon Location Service pricing. Defaults to None.
        pricing_plan_data_source(str, optional): Updates the data provider for the geofence collection.  A required value for the following pricing plans: MobileAssetTracking| MobileAssetManagement  For more information about data providers and pricing plans, see the Amazon Location Service product page.  This can only be updated when updating the PricingPlan in the same request. Amazon Location Service uses PricingPlanDataSource to calculate billing for your geofence collection. Your data won't be shared with the data provider, and will remain in your AWS account and Region unless you move it. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.geofence.collection.update(ctx, collection_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.geofence.collection.update collection_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="update_geofence_collection",
        op_kwargs={
            "CollectionName": collection_name,
            "Description": description,
            "PricingPlan": pricing_plan,
            "PricingPlanDataSource": pricing_plan_data_source,
        },
    )
