"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, collection_name: str, device_position_updates: List) -> Dict:
    r"""
    **Autogenerated function**

    Evaluates device positions against the geofence geometries from a given geofence collection. This operation always returns an empty response because geofences are asynchronously evaluated. The evaluation determines if the device has entered or exited a geofenced area, and then publishes one of the following events to Amazon EventBridge:    ENTER if Amazon Location determines that the tracked device has entered a geofenced area.    EXIT if Amazon Location determines that the tracked device has exited a geofenced area.    The last geofence that a device was observed within is tracked for 30 days after the most recent device position update.

    Args:
        collection_name(str): The geofence collection used in evaluating the position of devices against its geofences.
        device_position_updates(List): Contains device details for each device to be evaluated against the given geofence collection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.evaluate_geofence.batch(
                ctx, collection_name=value, device_position_updates=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.evaluate_geofence.batch collection_name=value, device_position_updates=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="batch_evaluate_geofences",
        op_kwargs={
            "CollectionName": collection_name,
            "DevicePositionUpdates": device_position_updates,
        },
    )
