"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, device_id: str, tracker_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a device's most recent position according to its sample time.  Device positions are deleted after 30 days.

    Args:
        device_id(str): The device whose position you want to retrieve.
        tracker_name(str): The tracker resource receiving the position update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.device_position.init.get(
                ctx, device_id=value, tracker_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.device_position.init.get device_id=value, tracker_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="get_device_position",
        op_kwargs={"DeviceId": device_id, "TrackerName": tracker_name},
    )


async def list_all(
    hub, ctx, tracker_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    A batch request to retrieve all device positions.

    Args:
        max_results(int, optional): An optional limit for the number of entries returned in a single call. Default value: 100 . Defaults to None.
        next_token(str, optional): The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. Default value: null . Defaults to None.
        tracker_name(str): The tracker resource containing the requested devices.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.device_position.init.list_all(ctx, tracker_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.device_position.init.list_all tracker_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="list_device_positions",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "TrackerName": tracker_name,
        },
    )
