"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    device_id: str,
    tracker_name: str,
    end_time_exclusive: str = None,
    next_token: str = None,
    start_time_inclusive: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the device position history from a tracker resource within a specified range of time.  Device positions are deleted after 30 days.

    Args:
        device_id(str): The device whose position history you want to retrieve.
        end_time_exclusive(str, optional): Specify the end time for the position history in  ISO 8601 format: YYYY-MM-DDThh:mm:ss.sssZ. By default, the value will be the time that the request is made. Requirement:   The time specified for EndTimeExclusive must be after the time for StartTimeInclusive.  . Defaults to None.
        next_token(str, optional): The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.  Default value: null . Defaults to None.
        start_time_inclusive(str, optional): Specify the start time for the position history in  ISO 8601 format: YYYY-MM-DDThh:mm:ss.sssZ. By default, the value will be 24 hours prior to the time that the request is made. Requirement:   The time specified for StartTimeInclusive must be before EndTimeExclusive.  . Defaults to None.
        tracker_name(str): The tracker resource receiving the request for the device position history.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.device_position.history.get(
                ctx, device_id=value, tracker_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.device_position.history.get device_id=value, tracker_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="get_device_position_history",
        op_kwargs={
            "DeviceId": device_id,
            "EndTimeExclusive": end_time_exclusive,
            "NextToken": next_token,
            "StartTimeInclusive": start_time_inclusive,
            "TrackerName": tracker_name,
        },
    )
