"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, collection_name: str, geofence_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a batch of geofences from a geofence collection.  This operation deletes the resource permanently.

    Args:
        collection_name(str): The geofence collection storing the geofences to be deleted.
        geofence_ids(List): The batch of geofences to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.delete.geofence.batch(
                ctx, collection_name=value, geofence_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.delete.geofence.batch collection_name=value, geofence_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="batch_delete_geofence",
        op_kwargs={"CollectionName": collection_name, "GeofenceIds": geofence_ids},
    )
