"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, device_ids: List, tracker_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the position history of one or more devices from a tracker resource.

    Args:
        device_ids(List): Devices whose position history you want to delete.   For example, for two devices: “DeviceIds” : [DeviceId1,DeviceId2]   .
        tracker_name(str): The name of the tracker resource to delete the device position history from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.location.delete.device_position_history.batch(
                ctx, device_ids=value, tracker_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.location.delete.device_position_history.batch device_ids=value, tracker_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="location",
        operation="batch_delete_device_position_history",
        op_kwargs={"DeviceIds": device_ids, "TrackerName": tracker_name},
    )
