"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"is_": "is"}


async def is_(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns a Boolean value indicating whether your Lightsail VPC is peered.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.vpc.peered.is(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.vpc.peered.is
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="lightsail", operation="is_vpc_peered", op_kwargs={}
    )
