"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def peer(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Peers the Lightsail VPC with the user's default VPC.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.vpc.init.peer(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.vpc.init.peer
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="lightsail", operation="peer_vpc", op_kwargs={}
    )


async def unpeer(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Unpeers the Lightsail VPC from the user's default VPC.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.vpc.init.unpeer(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.vpc.init.unpeer
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="lightsail", operation="unpeer_vpc", op_kwargs={}
    )
