"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def allocate(hub, ctx, static_ip_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Allocates a static IP address.

    Args:
        static_ip_name(str): The name of the static IP address.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.static_ip.allocate(ctx, static_ip_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.static_ip.allocate static_ip_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="allocate_static_ip",
        op_kwargs={"staticIpName": static_ip_name},
    )


async def attach(hub, ctx, static_ip_name: str, instance_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Attaches a static IP address to a specific Amazon Lightsail instance.

    Args:
        static_ip_name(str): The name of the static IP.
        instance_name(str): The instance name to which you want to attach the static IP address.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.static_ip.attach(
                ctx, static_ip_name=value, instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.static_ip.attach static_ip_name=value, instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="attach_static_ip",
        op_kwargs={"staticIpName": static_ip_name, "instanceName": instance_name},
    )


async def detach(hub, ctx, static_ip_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Detaches a static IP from the Amazon Lightsail instance to which it is attached.

    Args:
        static_ip_name(str): The name of the static IP to detach from the instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.static_ip.detach(ctx, static_ip_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.static_ip.detach static_ip_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="detach_static_ip",
        op_kwargs={"staticIpName": static_ip_name},
    )


async def get(hub, ctx, static_ip_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about an Amazon Lightsail static IP.

    Args:
        static_ip_name(str): The name of the static IP in Lightsail.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.static_ip.get(ctx, static_ip_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.static_ip.get static_ip_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_static_ip",
        op_kwargs={"staticIpName": static_ip_name},
    )


async def get_all(hub, ctx, page_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all static IPs in the user's account.

    Args:
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetStaticIps request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.static_ip.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.static_ip.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_static_ips",
        op_kwargs={"pageToken": page_token},
    )


async def release(hub, ctx, static_ip_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specific static IP from your account.

    Args:
        static_ip_name(str): The name of the static IP to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.static_ip.release(ctx, static_ip_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.static_ip.release static_ip_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="release_static_ip",
        op_kwargs={"staticIpName": static_ip_name},
    )
