"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def copy(
    hub,
    ctx,
    target_snapshot_name: str,
    source_region: str,
    source_snapshot_name: str = None,
    source_resource_name: str = None,
    restore_date: str = None,
    use_latest_restorable_auto_snapshot: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Copies a manual snapshot of an instance or disk as another manual snapshot, or copies an automatic snapshot of an instance or disk as a manual snapshot. This operation can also be used to copy a manual or automatic snapshot of an instance or a disk from one AWS Region to another in Amazon Lightsail. When copying a manual snapshot, be sure to define the source region, source snapshot name, and target snapshot name parameters. When copying an automatic snapshot, be sure to define the source region, source resource name, target snapshot name, and either the restore date or the use latest restorable auto snapshot parameters.

    Args:
        source_snapshot_name(str, optional): The name of the source manual snapshot to copy. Constraint:   Define this parameter only when copying a manual snapshot as another manual snapshot.  . Defaults to None.
        source_resource_name(str, optional): The name of the source instance or disk from which the source automatic snapshot was created. Constraint:   Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the Amazon Lightsail Developer Guide.  . Defaults to None.
        restore_date(str, optional): The date of the source automatic snapshot to copy. Use the get auto snapshots operation to identify the dates of the available automatic snapshots. Constraints:   Must be specified in YYYY-MM-DD format.   This parameter cannot be defined together with the use latest restorable auto snapshot parameter. The restore date and use latest restorable auto snapshot parameters are mutually exclusive.   Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the Amazon Lightsail Developer Guide.  . Defaults to None.
        use_latest_restorable_auto_snapshot(bool, optional): A Boolean value to indicate whether to use the latest available automatic snapshot of the specified source instance or disk. Constraints:   This parameter cannot be defined together with the restore date parameter. The use latest restorable auto snapshot and restore date parameters are mutually exclusive.   Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the Amazon Lightsail Developer Guide.  . Defaults to None.
        target_snapshot_name(str): The name of the new manual snapshot to be created as a copy.
        source_region(str): The AWS Region where the source manual or automatic snapshot is located.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.snapshot.copy(
                ctx, target_snapshot_name=value, source_region=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.snapshot.copy target_snapshot_name=value, source_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="copy_snapshot",
        op_kwargs={
            "sourceSnapshotName": source_snapshot_name,
            "sourceResourceName": source_resource_name,
            "restoreDate": restore_date,
            "useLatestRestorableAutoSnapshot": use_latest_restorable_auto_snapshot,
            "targetSnapshotName": target_snapshot_name,
            "sourceRegion": source_region,
        },
    )


async def export(hub, ctx, source_snapshot_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Exports an Amazon Lightsail instance or block storage disk snapshot to Amazon Elastic Compute Cloud (Amazon EC2). This operation results in an export snapshot record that can be used with the create cloud formation stack operation to create new Amazon EC2 instances. Exported instance snapshots appear in Amazon EC2 as Amazon Machine Images (AMIs), and the instance system disk appears as an Amazon Elastic Block Store (Amazon EBS) volume. Exported disk snapshots appear in Amazon EC2 as Amazon EBS volumes. Snapshots are exported to the same Amazon Web Services Region in Amazon EC2 as the source Lightsail snapshot.  The export snapshot operation supports tag-based access control via resource tags applied to the resource identified by source snapshot name. For more information, see the Amazon Lightsail Developer Guide.  Use the get instance snapshots or get disk snapshots operations to get a list of snapshots that you can export to Amazon EC2.

    Args:
        source_snapshot_name(str): The name of the instance or disk snapshot to be exported to Amazon EC2.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.snapshot.export(ctx, source_snapshot_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.snapshot.export source_snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="export_snapshot",
        op_kwargs={"sourceSnapshotName": source_snapshot_name},
    )
