"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(
    hub, ctx, resource_name: str, tags: List, resource_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more tags to the specified Amazon Lightsail resource. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see the Amazon Lightsail Developer Guide. The tag resource operation supports tag-based access control via request tags and resource tags applied to the resource identified by resource name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        resource_name(str): The name of the resource to which you are adding tags.
        resource_arn(str, optional): The Amazon Resource Name (ARN) of the resource to which you want to add a tag. Defaults to None.
        tags(List): The tag key and optional value.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.resource.init.tag(
                ctx, resource_name=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.resource.init.tag resource_name=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="tag_resource",
        op_kwargs={
            "resourceName": resource_name,
            "resourceArn": resource_arn,
            "tags": tags,
        },
    )


async def untag(
    hub, ctx, resource_name: str, tag_keys: List, resource_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified set of tag keys and their values from the specified Amazon Lightsail resource. The untag resource operation supports tag-based access control via request tags and resource tags applied to the resource identified by resource name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        resource_name(str): The name of the resource from which you are removing a tag.
        resource_arn(str, optional): The Amazon Resource Name (ARN) of the resource from which you want to remove a tag. Defaults to None.
        tag_keys(List): The tag keys to delete from the specified resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.resource.init.untag(
                ctx, resource_name=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.resource.init.untag resource_name=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="untag_resource",
        op_kwargs={
            "resourceName": resource_name,
            "resourceArn": resource_arn,
            "tagKeys": tag_keys,
        },
    )
