"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, resource_name: str, bucket_name: str, access: str) -> Dict:
    r"""
    **Autogenerated function**

    Sets the Amazon Lightsail resources that can access the specified Lightsail bucket. Lightsail buckets currently support setting access for Lightsail instances in the same AWS Region.

    Args:
        resource_name(str): The name of the Lightsail instance for which to set bucket access. The instance must be in a running or stopped state.
        bucket_name(str): The name of the bucket for which to set access to another Lightsail resource.
        access(str): The access setting. The following access settings are available:    allow - Allows access to the bucket and its objects.    deny - Denies access to the bucket and its objects. Use this setting to remove access for a resource previously set to allow.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.resource.access_for_bucket.set(
                ctx, resource_name=value, bucket_name=value, access=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.resource.access_for_bucket.set resource_name=value, bucket_name=value, access=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="set_resource_access_for_bucket",
        op_kwargs={
            "resourceName": resource_name,
            "bucketName": bucket_name,
            "access": access,
        },
    )
