"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    relational_database_name: str,
    relational_database_snapshot_name: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a snapshot of your database in Amazon Lightsail. You can use snapshots for backups, to make copies of a database, and to save data before deleting a database. The create relational database snapshot operation supports tag-based access control via request tags. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        relational_database_name(str): The name of the database on which to base your new snapshot.
        relational_database_snapshot_name(str): The name for your new database snapshot. Constraints:   Must contain from 2 to 255 alphanumeric characters, or hyphens.   The first and last character must be a letter or number.  .
        tags(List, optional): The tag keys and optional values to add to the resource during create. Use the TagResource action to tag a resource after it's created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.snapshot.create(
                ctx, relational_database_name=value, relational_database_snapshot_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.snapshot.create relational_database_name=value, relational_database_snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_relational_database_snapshot",
        op_kwargs={
            "relationalDatabaseName": relational_database_name,
            "relationalDatabaseSnapshotName": relational_database_snapshot_name,
            "tags": tags,
        },
    )


async def delete(hub, ctx, relational_database_snapshot_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a database snapshot in Amazon Lightsail. The delete relational database snapshot operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        relational_database_snapshot_name(str): The name of the database snapshot that you are deleting.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.snapshot.delete(
                ctx, relational_database_snapshot_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.snapshot.delete relational_database_snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_relational_database_snapshot",
        op_kwargs={"relationalDatabaseSnapshotName": relational_database_snapshot_name},
    )


async def get(hub, ctx, relational_database_snapshot_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific database snapshot in Amazon Lightsail.

    Args:
        relational_database_snapshot_name(str): The name of the database snapshot for which to get information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.snapshot.get(
                ctx, relational_database_snapshot_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.snapshot.get relational_database_snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_relational_database_snapshot",
        op_kwargs={"relationalDatabaseSnapshotName": relational_database_snapshot_name},
    )


async def get_all(hub, ctx, page_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all of your database snapshots in Amazon Lightsail.

    Args:
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetRelationalDatabaseSnapshots request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.snapshot.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.snapshot.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_relational_database_snapshots",
        op_kwargs={"pageToken": page_token},
    )
