"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, relational_database_name: str, password_version: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the current, previous, or pending versions of the master user password for a Lightsail database. The GetRelationalDatabaseMasterUserPassword operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName.

    Args:
        relational_database_name(str): The name of your database for which to get the master user password.
        password_version(str, optional): The password version to return. Specifying CURRENT or PREVIOUS returns the current or previous passwords respectively. Specifying PENDING returns the newest version of the password that will rotate to CURRENT. After the PENDING password rotates to CURRENT, the PENDING password is no longer available. Default: CURRENT . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.master_user_password.get(
                ctx, relational_database_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.master_user_password.get relational_database_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_relational_database_master_user_password",
        op_kwargs={
            "relationalDatabaseName": relational_database_name,
            "passwordVersion": password_version,
        },
    )
