"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, relational_database_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of available log streams for a specific database in Amazon Lightsail.

    Args:
        relational_database_name(str): The name of your database for which to get log streams.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.log.stream.get_all(
                ctx, relational_database_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.log.stream.get_all relational_database_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_relational_database_log_streams",
        op_kwargs={"relationalDatabaseName": relational_database_name},
    )
