"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    relational_database_name: str,
    log_stream_name: str,
    start_time: str = None,
    end_time: str = None,
    start_from_head: bool = None,
    page_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of log events for a database in Amazon Lightsail.

    Args:
        relational_database_name(str): The name of your database for which to get log events.
        log_stream_name(str): The name of the log stream. Use the get relational database log streams operation to get a list of available log streams.
        start_time(str, optional): The start of the time interval from which to get log events. Constraints:   Specified in Coordinated Universal Time (UTC).   Specified in the Unix time format. For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input 1538424000 as the start time.  . Defaults to None.
        end_time(str, optional): The end of the time interval from which to get log events. Constraints:   Specified in Coordinated Universal Time (UTC).   Specified in the Unix time format. For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input 1538424000 as the end time.  . Defaults to None.
        start_from_head(bool, optional): Parameter to specify if the log should start from head or tail. If true is specified, the log event starts from the head of the log. If false is specified, the log event starts from the tail of the log.  For PostgreSQL, the default value of false is the only option available. . Defaults to None.
        page_token(str, optional): The token to advance to the next or previous page of results from your request. To get a page token, perform an initial GetRelationalDatabaseLogEvents request. If your results are paginated, the response will return a next forward token and/or next backward token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.log.event.get_all(
                ctx, relational_database_name=value, log_stream_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.log.event.get_all relational_database_name=value, log_stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_relational_database_log_events",
        op_kwargs={
            "relationalDatabaseName": relational_database_name,
            "logStreamName": log_stream_name,
            "startTime": start_time,
            "endTime": end_time,
            "startFromHead": start_from_head,
            "pageToken": page_token,
        },
    )
