"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    relational_database_name: str,
    relational_database_blueprint_id: str,
    relational_database_bundle_id: str,
    master_database_name: str,
    master_username: str,
    availability_zone: str = None,
    master_user_password: str = None,
    preferred_backup_window: str = None,
    preferred_maintenance_window: str = None,
    publicly_accessible: bool = None,
    tags: List = None,
) -> Dict:
    r'''
    **Autogenerated function**

    Creates a new database in Amazon Lightsail. The create relational database operation supports tag-based access control via request tags. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        relational_database_name(str): The name to use for your new Lightsail database resource. Constraints:   Must contain from 2 to 255 alphanumeric characters, or hyphens.   The first and last character must be a letter or number.  .
        availability_zone(str, optional): The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format. You can get a list of Availability Zones by using the get regions operation. Be sure to add the include relational database Availability Zones parameter to your request. Defaults to None.
        relational_database_blueprint_id(str): The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the get relational database blueprints operation.
        relational_database_bundle_id(str): The bundle ID for your new database. A bundle describes the performance specifications for your database. You can get a list of database bundle IDs by using the get relational database bundles operation.
        master_database_name(str): The meaning of this parameter differs according to the database engine you use.  MySQL  The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, no database is created in the database resource. Constraints:   Must contain 1 to 64 letters or numbers.   Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0- 9).   Can't be a word reserved by the specified database engine. For more information about reserved words in MySQL, see the Keywords and Reserved Words articles for MySQL 5.6, MySQL 5.7, and MySQL 8.0.    PostgreSQL  The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, a database named postgres is created in the database resource. Constraints:   Must contain 1 to 63 letters or numbers.   Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0- 9).   Can't be a word reserved by the specified database engine. For more information about reserved words in PostgreSQL, see the SQL Key Words articles for PostgreSQL 9.6, PostgreSQL 10, PostgreSQL 11, and PostgreSQL 12.  .
        master_username(str): The name for the master user.  MySQL  Constraints:   Required for MySQL.   Must be 1 to 16 letters or numbers. Can contain underscores.   First character must be a letter.   Can't be a reserved word for the chosen database engine. For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for MySQL 5.6, MySQL 5.7, or MySQL 8.0.    PostgreSQL  Constraints:   Required for PostgreSQL.   Must be 1 to 63 letters or numbers. Can contain underscores.   First character must be a letter.   Can't be a reserved word for the chosen database engine. For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for PostgreSQL 9.6, PostgreSQL 10, PostgreSQL 11, and PostgreSQL 12.  .
        master_user_password(str, optional): The password for the master user. The password can include any printable ASCII character except "/", """, or "@". It cannot contain spaces.  MySQL  Constraints: Must contain from 8 to 41 characters.  PostgreSQL  Constraints: Must contain from 8 to 128 characters. Defaults to None.
        preferred_backup_window(str, optional): The daily time range during which automated backups are created for your new database if automated backups are enabled. The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. For more information about the preferred backup window time blocks for each region, see the Working With Backups guide in the Amazon Relational Database Service (Amazon RDS) documentation. Constraints:   Must be in the hh24:mi-hh24:mi format. Example: 16:00-16:30    Specified in Coordinated Universal Time (UTC).   Must not conflict with the preferred maintenance window.   Must be at least 30 minutes.  . Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range during which system maintenance can occur on your new database. The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. Constraints:   Must be in the ddd:hh24:mi-ddd:hh24:mi format.   Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.   Must be at least 30 minutes.   Specified in Coordinated Universal Time (UTC).   Example: Tue:17:00-Tue:17:30   . Defaults to None.
        publicly_accessible(bool, optional): Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database. Defaults to None.
        tags(List, optional): The tag keys and optional values to add to the resource during create. Use the TagResource action to tag a resource after it's created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.init.create(
                ctx,
                relational_database_name=value,
                relational_database_blueprint_id=value,
                relational_database_bundle_id=value,
                master_database_name=value,
                master_username=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.init.create relational_database_name=value, relational_database_blueprint_id=value, relational_database_bundle_id=value, master_database_name=value, master_username=value
    '''
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_relational_database",
        op_kwargs={
            "relationalDatabaseName": relational_database_name,
            "availabilityZone": availability_zone,
            "relationalDatabaseBlueprintId": relational_database_blueprint_id,
            "relationalDatabaseBundleId": relational_database_bundle_id,
            "masterDatabaseName": master_database_name,
            "masterUsername": master_username,
            "masterUserPassword": master_user_password,
            "preferredBackupWindow": preferred_backup_window,
            "preferredMaintenanceWindow": preferred_maintenance_window,
            "publiclyAccessible": publicly_accessible,
            "tags": tags,
        },
    )


async def delete(
    hub,
    ctx,
    relational_database_name: str,
    skip_final_snapshot: bool = None,
    final_relational_database_snapshot_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a database in Amazon Lightsail. The delete relational database operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        relational_database_name(str): The name of the database that you are deleting.
        skip_final_snapshot(bool, optional): Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false. Default: false . Defaults to None.
        final_relational_database_snapshot_name(str, optional): The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.  Specifying this parameter and also specifying the skip final snapshot parameter to true results in an error.  Constraints:   Must contain from 2 to 255 alphanumeric characters, or hyphens.   The first and last character must be a letter or number.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.init.delete(
                ctx, relational_database_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.init.delete relational_database_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_relational_database",
        op_kwargs={
            "relationalDatabaseName": relational_database_name,
            "skipFinalSnapshot": skip_final_snapshot,
            "finalRelationalDatabaseSnapshotName": final_relational_database_snapshot_name,
        },
    )


async def get(hub, ctx, relational_database_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific database in Amazon Lightsail.

    Args:
        relational_database_name(str): The name of the database that you are looking up.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.init.get(
                ctx, relational_database_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.init.get relational_database_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_relational_database",
        op_kwargs={"relationalDatabaseName": relational_database_name},
    )


async def get_all(hub, ctx, page_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all of your databases in Amazon Lightsail.

    Args:
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetRelationalDatabases request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_relational_databases",
        op_kwargs={"pageToken": page_token},
    )


async def reboot(hub, ctx, relational_database_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Restarts a specific database in Amazon Lightsail. The reboot relational database operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        relational_database_name(str): The name of your database to reboot.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.init.reboot(
                ctx, relational_database_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.init.reboot relational_database_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="reboot_relational_database",
        op_kwargs={"relationalDatabaseName": relational_database_name},
    )


async def start(hub, ctx, relational_database_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts a specific database from a stopped state in Amazon Lightsail. To restart a database, use the reboot relational database operation. The start relational database operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        relational_database_name(str): The name of your database to start.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.init.start(
                ctx, relational_database_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.init.start relational_database_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="start_relational_database",
        op_kwargs={"relationalDatabaseName": relational_database_name},
    )


async def stop(
    hub,
    ctx,
    relational_database_name: str,
    relational_database_snapshot_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Stops a specific database that is currently running in Amazon Lightsail. The stop relational database operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        relational_database_name(str): The name of your database to stop.
        relational_database_snapshot_name(str, optional): The name of your new database snapshot to be created before stopping your database. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.init.stop(
                ctx, relational_database_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.init.stop relational_database_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="stop_relational_database",
        op_kwargs={
            "relationalDatabaseName": relational_database_name,
            "relationalDatabaseSnapshotName": relational_database_snapshot_name,
        },
    )


async def update(
    hub,
    ctx,
    relational_database_name: str,
    master_user_password: str = None,
    rotate_master_user_password: bool = None,
    preferred_backup_window: str = None,
    preferred_maintenance_window: str = None,
    enable_backup_retention: bool = None,
    disable_backup_retention: bool = None,
    publicly_accessible: bool = None,
    apply_immediately: bool = None,
    ca_certificate_identifier: str = None,
) -> Dict:
    r'''
    **Autogenerated function**

    Allows the update of one or more attributes of a database in Amazon Lightsail. Updates are applied immediately, or in cases where the updates could result in an outage, are applied during the database's predefined maintenance window. The update relational database operation supports tag-based access control via resource tags applied to the resource identified by relationalDatabaseName. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        relational_database_name(str): The name of your Lightsail database resource to update.
        master_user_password(str, optional): The password for the master user. The password can include any printable ASCII character except "/", """, or "@". MySQL  Constraints: Must contain from 8 to 41 characters.  PostgreSQL  Constraints: Must contain from 8 to 128 characters. Defaults to None.
        rotate_master_user_password(bool, optional): When true, the master user password is changed to a new strong password generated by Lightsail. Use the get relational database master user password operation to get the new password. Defaults to None.
        preferred_backup_window(str, optional): The daily time range during which automated backups are created for your database if automated backups are enabled. Constraints:   Must be in the hh24:mi-hh24:mi format. Example: 16:00-16:30    Specified in Coordinated Universal Time (UTC).   Must not conflict with the preferred maintenance window.   Must be at least 30 minutes.  . Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range during which system maintenance can occur on your database. The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. Constraints:   Must be in the ddd:hh24:mi-ddd:hh24:mi format.   Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.   Must be at least 30 minutes.   Specified in Coordinated Universal Time (UTC).   Example: Tue:17:00-Tue:17:30   . Defaults to None.
        enable_backup_retention(bool, optional): When true, enables automated backup retention for your database. Updates are applied during the next maintenance window because this can result in an outage. Defaults to None.
        disable_backup_retention(bool, optional): When true, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database using the create relational database snapshot operation. Updates are applied during the next maintenance window because this can result in an outage. Defaults to None.
        publicly_accessible(bool, optional): Specifies the accessibility options for your database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database. Defaults to None.
        apply_immediately(bool, optional): When true, applies changes immediately. When false, applies changes during the preferred maintenance window. Some changes may cause an outage. Default: false . Defaults to None.
        ca_certificate_identifier(str, optional): Indicates the certificate that needs to be associated with the database. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.init.update(
                ctx, relational_database_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.init.update relational_database_name=value
    '''
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="update_relational_database",
        op_kwargs={
            "relationalDatabaseName": relational_database_name,
            "masterUserPassword": master_user_password,
            "rotateMasterUserPassword": rotate_master_user_password,
            "preferredBackupWindow": preferred_backup_window,
            "preferredMaintenanceWindow": preferred_maintenance_window,
            "enableBackupRetention": enable_backup_retention,
            "disableBackupRetention": disable_backup_retention,
            "publiclyAccessible": publicly_accessible,
            "applyImmediately": apply_immediately,
            "caCertificateIdentifier": ca_certificate_identifier,
        },
    )
