"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    relational_database_name: str,
    availability_zone: str = None,
    publicly_accessible: bool = None,
    relational_database_snapshot_name: str = None,
    relational_database_bundle_id: str = None,
    source_relational_database_name: str = None,
    restore_time: str = None,
    use_latest_restorable_time: bool = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new database from an existing database snapshot in Amazon Lightsail. You can create a new database from a snapshot in if something goes wrong with your original database, or to change it to a different plan, such as a high availability or standard plan. The create relational database from snapshot operation supports tag-based access control via request tags and resource tags applied to the resource identified by relationalDatabaseSnapshotName. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        relational_database_name(str): The name to use for your new Lightsail database resource. Constraints:   Must contain from 2 to 255 alphanumeric characters, or hyphens.   The first and last character must be a letter or number.  .
        availability_zone(str, optional): The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format. You can get a list of Availability Zones by using the get regions operation. Be sure to add the include relational database Availability Zones parameter to your request. Defaults to None.
        publicly_accessible(bool, optional): Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database. Defaults to None.
        relational_database_snapshot_name(str, optional): The name of the database snapshot from which to create your new database. Defaults to None.
        relational_database_bundle_id(str, optional): The bundle ID for your new database. A bundle describes the performance specifications for your database. You can get a list of database bundle IDs by using the get relational database bundles operation. When creating a new database from a snapshot, you cannot choose a bundle that is smaller than the bundle of the source database. Defaults to None.
        source_relational_database_name(str, optional): The name of the source database. Defaults to None.
        restore_time(str, optional): The date and time to restore your database from. Constraints:   Must be before the latest restorable time for the database.   Cannot be specified if the use latest restorable time parameter is true.   Specified in Coordinated Universal Time (UTC).   Specified in the Unix time format. For example, if you wish to use a restore time of October 1, 2018, at 8 PM UTC, then you input 1538424000 as the restore time.  . Defaults to None.
        use_latest_restorable_time(bool, optional): Specifies whether your database is restored from the latest backup time. A value of true restores from the latest backup time.  Default: false  Constraints: Cannot be specified if the restore time parameter is provided. Defaults to None.
        tags(List, optional): The tag keys and optional values to add to the resource during create. Use the TagResource action to tag a resource after it's created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.relational_database.from_snapshot.create(
                ctx, relational_database_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.relational_database.from_snapshot.create relational_database_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_relational_database_from_snapshot",
        op_kwargs={
            "relationalDatabaseName": relational_database_name,
            "availabilityZone": availability_zone,
            "publiclyAccessible": publicly_accessible,
            "relationalDatabaseSnapshotName": relational_database_snapshot_name,
            "relationalDatabaseBundleId": relational_database_bundle_id,
            "sourceRelationalDatabaseName": source_relational_database_name,
            "restoreTime": restore_time,
            "useLatestRestorableTime": use_latest_restorable_time,
            "tags": tags,
        },
    )
