"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    include_availability_zones: bool = None,
    include_relational_database_availability_zones: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all valid regions for Amazon Lightsail. Use the include availability zones parameter to also return the Availability Zones in a region.

    Args:
        include_availability_zones(bool, optional): A Boolean value indicating whether to also include Availability Zones in your get regions request. Availability Zones are indicated with a letter: e.g., us-east-2a. Defaults to None.
        include_relational_database_availability_zones(bool, optional): A Boolean value indicating whether to also include Availability Zones for databases in your get regions request. Availability Zones are indicated with a letter (e.g., us-east-2a). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.region.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.region.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_regions",
        op_kwargs={
            "includeAvailabilityZones": include_availability_zones,
            "includeRelationalDatabaseAvailabilityZones": include_relational_database_availability_zones,
        },
    )
