"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, operation_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific operation. Operations include events such as when you create an instance, allocate a static IP, attach a static IP, and so on.

    Args:
        operation_id(str): A GUID used to identify the operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.operation.init.get(ctx, operation_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.operation.init.get operation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_operation",
        op_kwargs={"operationId": operation_id},
    )


async def get_all(hub, ctx, page_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all operations. Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each subsequent call to GetOperations use the maximum (last) statusChangedAt value from the previous request.

    Args:
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetOperations request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.operation.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.operation.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_operations",
        op_kwargs={"pageToken": page_token},
    )
