"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, resource_name: str, page_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets operations for a specific resource (e.g., an instance or a static IP).

    Args:
        resource_name(str): The name of the resource for which you are requesting information.
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetOperationsForResource request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.operation.for_resource.get(ctx, resource_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.operation.for_resource.get resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_operations_for_resource",
        op_kwargs={"resourceName": resource_name, "pageToken": page_token},
    )
