"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(hub, ctx, load_balancer_name: str, certificate_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an updated, more secure version of Secure Socket Layer (SSL). Once you create and validate your certificate, you can attach it to your load balancer. You can also use this API to rotate the certificates on your account. Use the AttachLoadBalancerTlsCertificate action with the non-attached certificate, and it will replace the existing one and become the attached certificate. The AttachLoadBalancerTlsCertificate operation supports tag-based access control via resource tags applied to the resource identified by load balancer name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        load_balancer_name(str): The name of the load balancer to which you want to associate the SSL/TLS certificate.
        certificate_name(str): The name of your SSL/TLS certificate.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.load_balancer.tls_certificate.attach(
                ctx, load_balancer_name=value, certificate_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.load_balancer.tls_certificate.attach load_balancer_name=value, certificate_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="attach_load_balancer_tls_certificate",
        op_kwargs={
            "loadBalancerName": load_balancer_name,
            "certificateName": certificate_name,
        },
    )


async def create(
    hub,
    ctx,
    load_balancer_name: str,
    certificate_name: str,
    certificate_domain_name: str,
    certificate_alternative_names: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an SSL/TLS certificate for an Amazon Lightsail load balancer. TLS is just an updated, more secure version of Secure Socket Layer (SSL). The CreateLoadBalancerTlsCertificate operation supports tag-based access control via resource tags applied to the resource identified by load balancer name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        load_balancer_name(str): The load balancer name where you want to create the SSL/TLS certificate.
        certificate_name(str): The SSL/TLS certificate name. You can have up to 10 certificates in your account at one time. Each Lightsail load balancer can have up to 2 certificates associated with it at one time. There is also an overall limit to the number of certificates that can be issue in a 365-day period. For more information, see Limits.
        certificate_domain_name(str): The domain name (e.g., example.com) for your SSL/TLS certificate.
        certificate_alternative_names(List, optional): An array of strings listing alternative domains and subdomains for your SSL/TLS certificate. Lightsail will de-dupe the names for you. You can have a maximum of 9 alternative names (in addition to the 1 primary domain). We do not support wildcards (e.g., *.example.com). Defaults to None.
        tags(List, optional): The tag keys and optional values to add to the resource during create. Use the TagResource action to tag a resource after it's created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.load_balancer.tls_certificate.create(
                ctx, load_balancer_name=value, certificate_name=value, certificate_domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.load_balancer.tls_certificate.create load_balancer_name=value, certificate_name=value, certificate_domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_load_balancer_tls_certificate",
        op_kwargs={
            "loadBalancerName": load_balancer_name,
            "certificateName": certificate_name,
            "certificateDomainName": certificate_domain_name,
            "certificateAlternativeNames": certificate_alternative_names,
            "tags": tags,
        },
    )


async def delete(
    hub, ctx, load_balancer_name: str, certificate_name: str, force: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an SSL/TLS certificate associated with a Lightsail load balancer. The DeleteLoadBalancerTlsCertificate operation supports tag-based access control via resource tags applied to the resource identified by load balancer name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        load_balancer_name(str): The load balancer name.
        certificate_name(str): The SSL/TLS certificate name.
        force(bool, optional): When true, forces the deletion of an SSL/TLS certificate. There can be two certificates associated with a Lightsail load balancer: the primary and the backup. The force parameter is required when the primary SSL/TLS certificate is in use by an instance attached to the load balancer. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.load_balancer.tls_certificate.delete(
                ctx, load_balancer_name=value, certificate_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.load_balancer.tls_certificate.delete load_balancer_name=value, certificate_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_load_balancer_tls_certificate",
        op_kwargs={
            "loadBalancerName": load_balancer_name,
            "certificateName": certificate_name,
            "force": force,
        },
    )


async def get_all(hub, ctx, load_balancer_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the TLS certificates that are associated with the specified Lightsail load balancer. TLS is just an updated, more secure version of Secure Socket Layer (SSL). You can have a maximum of 2 certificates associated with a Lightsail load balancer. One is active and the other is inactive.

    Args:
        load_balancer_name(str): The name of the load balancer you associated with your SSL/TLS certificate.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.load_balancer.tls_certificate.get_all(
                ctx, load_balancer_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.load_balancer.tls_certificate.get_all load_balancer_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_load_balancer_tls_certificates",
        op_kwargs={"loadBalancerName": load_balancer_name},
    )
