"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    load_balancer_name: str,
    instance_port: int,
    health_check_path: str = None,
    certificate_name: str = None,
    certificate_domain_name: str = None,
    certificate_alternative_names: List = None,
    tags: List = None,
    ip_address_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see Configure your Lightsail instances for load balancing. You can create up to 5 load balancers per AWS Region in your account. When you create a load balancer, you can specify a unique name and port settings. To change additional load balancer settings, use the UpdateLoadBalancerAttribute operation. The create load balancer operation supports tag-based access control via request tags. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        load_balancer_name(str): The name of your load balancer.
        instance_port(int): The instance port where you're creating your load balancer.
        health_check_path(str, optional): The path you provided to perform the load balancer health check. If you didn't specify a health check path, Lightsail uses the root path of your website (e.g., "/"). You may want to specify a custom health check path other than the root of your application if your home page loads slowly or has a lot of media or scripting on it. Defaults to None.
        certificate_name(str, optional): The name of the SSL/TLS certificate. If you specify certificateName, then certificateDomainName is required (and vice-versa). Defaults to None.
        certificate_domain_name(str, optional): The domain name with which your certificate is associated (e.g., example.com). If you specify certificateDomainName, then certificateName is required (and vice-versa). Defaults to None.
        certificate_alternative_names(List, optional): The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g., www.example.com, example.com, m.example.com, blog.example.com). Defaults to None.
        tags(List, optional): The tag keys and optional values to add to the resource during create. Use the TagResource action to tag a resource after it's created. Defaults to None.
        ip_address_type(str, optional): The IP address type for the load balancer. The possible values are ipv4 for IPv4 only, and dualstack for IPv4 and IPv6. The default value is dualstack. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.load_balancer.init.create(
                ctx, load_balancer_name=value, instance_port=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.load_balancer.init.create load_balancer_name=value, instance_port=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_load_balancer",
        op_kwargs={
            "loadBalancerName": load_balancer_name,
            "instancePort": instance_port,
            "healthCheckPath": health_check_path,
            "certificateName": certificate_name,
            "certificateDomainName": certificate_domain_name,
            "certificateAlternativeNames": certificate_alternative_names,
            "tags": tags,
            "ipAddressType": ip_address_type,
        },
    )


async def delete(hub, ctx, load_balancer_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the load balancer is deleted, you will need to create a new load balancer, create a new certificate, and verify domain ownership again. The delete load balancer operation supports tag-based access control via resource tags applied to the resource identified by load balancer name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        load_balancer_name(str): The name of the load balancer you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.load_balancer.init.delete(
                ctx, load_balancer_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.load_balancer.init.delete load_balancer_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_load_balancer",
        op_kwargs={"loadBalancerName": load_balancer_name},
    )


async def get(hub, ctx, load_balancer_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified Lightsail load balancer.

    Args:
        load_balancer_name(str): The name of the load balancer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.load_balancer.init.get(ctx, load_balancer_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.load_balancer.init.get load_balancer_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_load_balancer",
        op_kwargs={"loadBalancerName": load_balancer_name},
    )


async def get_all(hub, ctx, page_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all load balancers in an account.

    Args:
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetLoadBalancers request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.load_balancer.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.load_balancer.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_load_balancers",
        op_kwargs={"pageToken": page_token},
    )
