"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, load_balancer_name: str, attribute_name: str, attribute_value: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified attribute for a load balancer. You can only update one attribute at a time. The update load balancer attribute operation supports tag-based access control via resource tags applied to the resource identified by load balancer name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        load_balancer_name(str): The name of the load balancer that you want to modify (e.g., my-load-balancer.
        attribute_name(str): The name of the attribute you want to update. Valid values are below.
        attribute_value(str): The value that you want to specify for the attribute name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.load_balancer.attribute.update(
                ctx, load_balancer_name=value, attribute_name=value, attribute_value=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.load_balancer.attribute.update load_balancer_name=value, attribute_name=value, attribute_value=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="update_load_balancer_attribute",
        op_kwargs={
            "loadBalancerName": load_balancer_name,
            "attributeName": attribute_name,
            "attributeValue": attribute_value,
        },
    )
