"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete_multiple(hub, ctx, instance_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the known host key or certificate used by the Amazon Lightsail browser-based SSH or RDP clients to authenticate an instance. This operation enables the Lightsail browser-based SSH or RDP clients to connect to the instance after a host key mismatch.  Perform this operation only if you were expecting the host key or certificate mismatch or if you are familiar with the new host key or certificate on the instance. For more information, see Troubleshooting connection issues when using the Amazon Lightsail browser-based SSH or RDP client.

    Args:
        instance_name(str): The name of the instance for which you want to reset the host key or certificate.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.known_host_key.delete_multiple(
                ctx, instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.known_host_key.delete_multiple instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_known_host_keys",
        op_kwargs={"instanceName": instance_name},
    )
