"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"import_": "import"}


async def create(hub, ctx, key_pair_name: str, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates an SSH key pair. The create key pair operation supports tag-based access control via request tags. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        key_pair_name(str): The name for your new key pair.
        tags(List, optional): The tag keys and optional values to add to the resource during create. Use the TagResource action to tag a resource after it's created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.key_pair.create(ctx, key_pair_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.key_pair.create key_pair_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_key_pair",
        op_kwargs={"keyPairName": key_pair_name, "tags": tags},
    )


async def delete(hub, ctx, key_pair_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specific SSH key pair. The delete key pair operation supports tag-based access control via resource tags applied to the resource identified by key pair name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        key_pair_name(str): The name of the key pair to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.key_pair.delete(ctx, key_pair_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.key_pair.delete key_pair_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_key_pair",
        op_kwargs={"keyPairName": key_pair_name},
    )


async def get(hub, ctx, key_pair_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific key pair.

    Args:
        key_pair_name(str): The name of the key pair for which you are requesting information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.key_pair.get(ctx, key_pair_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.key_pair.get key_pair_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_key_pair",
        op_kwargs={"keyPairName": key_pair_name},
    )


async def get_all(hub, ctx, page_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all key pairs in the user's account.

    Args:
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetKeyPairs request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.key_pair.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.key_pair.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_key_pairs",
        op_kwargs={"pageToken": page_token},
    )


async def import_(hub, ctx, key_pair_name: str, public_key_base64: str) -> Dict:
    r"""
    **Autogenerated function**

    Imports a public SSH key from a specific key pair.

    Args:
        key_pair_name(str): The name of the key pair for which you want to import the public key.
        public_key_base64(str): A base64-encoded public key of the ssh-rsa type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.key_pair.import(ctx, key_pair_name=value, public_key_base64=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.key_pair.import key_pair_name=value, public_key_base64=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="import_key_pair",
        op_kwargs={"keyPairName": key_pair_name, "publicKeyBase64": public_key_base64},
    )
