"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "ip_address_type"


__func_alias__ = {"set_": "set"}


async def set_(
    hub, ctx, resource_type: str, resource_name: str, ip_address_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Sets the IP address type for an Amazon Lightsail resource. Use this action to enable dual-stack for a resource, which enables IPv4 and IPv6 for the specified resource. Alternately, you can use this action to disable dual-stack, and enable IPv4 only.

    Args:
        resource_type(str): The resource type. The possible values are Distribution, Instance, and LoadBalancer.  Distribution-related APIs are available only in the N. Virginia (us-east-1) AWS Region. Set your AWS Region configuration to us-east-1 to create, view, or edit distributions. .
        resource_name(str): The name of the resource for which to set the IP address type.
        ip_address_type(str): The IP address type to set for the specified resource. The possible values are ipv4 for IPv4 only, and dualstack for IPv4 and IPv6.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.ip_address_type_.set(
                ctx, resource_type=value, resource_name=value, ip_address_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.ip_address_type.set resource_type=value, resource_name=value, ip_address_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="set_ip_address_type",
        op_kwargs={
            "resourceType": resource_type,
            "resourceName": resource_name,
            "ipAddressType": ip_address_type,
        },
    )
