"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(hub, ctx, load_balancer_name: str, instance_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Attaches one or more Lightsail instances to a load balancer. After some time, the instances are attached to the load balancer and the health check status is available. The attach instances to load balancer operation supports tag-based access control via resource tags applied to the resource identified by load balancer name. For more information, see the Lightsail Developer Guide.

    Args:
        load_balancer_name(str): The name of the load balancer.
        instance_names(List): An array of strings representing the instance name(s) you want to attach to your load balancer. An instance must be running before you can attach it to your load balancer. There are no additional limits on the number of instances you can attach to your load balancer, aside from the limit of Lightsail instances you can create in your account (20).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.to_load_balancer.attach(
                ctx, load_balancer_name=value, instance_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.to_load_balancer.attach load_balancer_name=value, instance_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="attach_instances_to_load_balancer",
        op_kwargs={
            "loadBalancerName": load_balancer_name,
            "instanceNames": instance_names,
        },
    )
