"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, instance_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the state of a specific instance. Works on one instance at a time.

    Args:
        instance_name(str): The name of the instance to get state information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.state.get(ctx, instance_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.state.get instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_instance_state",
        op_kwargs={"instanceName": instance_name},
    )
