"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, instance_snapshot_name: str, instance_name: str, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a snapshot of a specific virtual private server, or instance. You can use a snapshot to create a new instance that is based on that snapshot. The create instance snapshot operation supports tag-based access control via request tags. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        instance_snapshot_name(str): The name for your new snapshot.
        instance_name(str): The Lightsail instance on which to base your snapshot.
        tags(List, optional): The tag keys and optional values to add to the resource during create. Use the TagResource action to tag a resource after it's created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.snapshot.create(
                ctx, instance_snapshot_name=value, instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.snapshot.create instance_snapshot_name=value, instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_instance_snapshot",
        op_kwargs={
            "instanceSnapshotName": instance_snapshot_name,
            "instanceName": instance_name,
            "tags": tags,
        },
    )


async def delete(hub, ctx, instance_snapshot_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specific snapshot of a virtual private server (or instance). The delete instance snapshot operation supports tag-based access control via resource tags applied to the resource identified by instance snapshot name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        instance_snapshot_name(str): The name of the snapshot to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.snapshot.delete(
                ctx, instance_snapshot_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.snapshot.delete instance_snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_instance_snapshot",
        op_kwargs={"instanceSnapshotName": instance_snapshot_name},
    )


async def get(hub, ctx, instance_snapshot_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific instance snapshot.

    Args:
        instance_snapshot_name(str): The name of the snapshot for which you are requesting information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.snapshot.get(
                ctx, instance_snapshot_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.snapshot.get instance_snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_instance_snapshot",
        op_kwargs={"instanceSnapshotName": instance_snapshot_name},
    )


async def get_all(hub, ctx, page_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns all instance snapshots for the user's account.

    Args:
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetInstanceSnapshots request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.snapshot.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.snapshot.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_instance_snapshots",
        op_kwargs={"pageToken": page_token},
    )
