"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"open_": "open"}


async def close(hub, ctx, port_info: Dict, instance_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Closes ports for a specific Amazon Lightsail instance. The CloseInstancePublicPorts action supports tag-based access control via resource tags applied to the resource identified by instanceName. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        port_info(Dict): An object to describe the ports to close for the specified instance.
        instance_name(str): The name of the instance for which to close ports.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.public_port.close(
                ctx, port_info=value, instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.public_port.close port_info=value, instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="close_instance_public_ports",
        op_kwargs={"portInfo": port_info, "instanceName": instance_name},
    )


async def open_(hub, ctx, port_info: Dict, instance_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol. The OpenInstancePublicPorts action supports tag-based access control via resource tags applied to the resource identified by instanceName. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        port_info(Dict): An object to describe the ports to open for the specified instance.
        instance_name(str): The name of the instance for which to open ports.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.public_port.open(
                ctx, port_info=value, instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.public_port.open port_info=value, instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="open_instance_public_ports",
        op_kwargs={"portInfo": port_info, "instanceName": instance_name},
    )


async def put_multiple(hub, ctx, port_infos: List, instance_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol. This action also closes all currently open ports that are not included in the request. Include all of the ports and the protocols you want to open in your PutInstancePublicPortsrequest. Or use the OpenInstancePublicPorts action to open ports without closing currently open ports. The PutInstancePublicPorts action supports tag-based access control via resource tags applied to the resource identified by instanceName. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        port_infos(List): An array of objects to describe the ports to open for the specified instance.
        instance_name(str): The name of the instance for which to open ports.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.public_port.put_multiple(
                ctx, port_infos=value, instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.public_port.put_multiple port_infos=value, instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="put_instance_public_ports",
        op_kwargs={"portInfos": port_infos, "instanceName": instance_name},
    )
