"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, instance_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the firewall port states for a specific Amazon Lightsail instance, the IP addresses allowed to connect to the instance through the ports, and the protocol.

    Args:
        instance_name(str): The name of the instance for which to return firewall port states.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.port_state.get_all(ctx, instance_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.port_state.get_all instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_instance_port_states",
        op_kwargs={"instanceName": instance_name},
    )
