"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(
    hub,
    ctx,
    instance_names: List,
    availability_zone: str,
    blueprint_id: str,
    bundle_id: str,
    custom_image_name: str = None,
    user_data: str = None,
    key_pair_name: str = None,
    tags: List = None,
    add_ons: List = None,
    ip_address_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates one or more Amazon Lightsail instances. The create instances operation supports tag-based access control via request tags. For more information, see the Lightsail Developer Guide.

    Args:
        instance_names(List): The names to use for your new Lightsail instances. Separate multiple values using quotation marks and commas, for example: ["MyFirstInstance","MySecondInstance"] .
        availability_zone(str): The Availability Zone in which to create your instance. Use the following format: us-east-2a (case sensitive). You can get a list of Availability Zones by using the get regions operation. Be sure to add the include Availability Zones parameter to your request.
        custom_image_name(str, optional): (Deprecated) The name for your custom image.  In releases prior to June 12, 2017, this parameter was ignored by the API. It is now deprecated. . Defaults to None.
        blueprint_id(str): The ID for a virtual private server image (e.g., app_wordpress_4_4 or app_lamp_7_0). Use the get blueprints operation to return a list of available images (or blueprints).  Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when they become outdated due to operating system updates or new application releases. .
        bundle_id(str): The bundle of specification information for your virtual private server (or instance), including the pricing plan (e.g., micro_1_0).
        user_data(str, optional): A launch script you can create that configures a server with additional user data. For example, you might want to run apt-get -y update.  Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use yum, Debian and Ubuntu use apt-get, and FreeBSD uses pkg. For a complete list, see the Amazon Lightsail Developer Guide. . Defaults to None.
        key_pair_name(str, optional): The name of your key pair. Defaults to None.
        tags(List, optional): The tag keys and optional values to add to the resource during create. Use the TagResource action to tag a resource after it's created. Defaults to None.
        add_ons(List, optional): An array of objects representing the add-ons to enable for the new instance. Defaults to None.
        ip_address_type(str, optional): The IP address type for the instance. The possible values are ipv4 for IPv4 only, and dualstack for IPv4 and IPv6. The default value is dualstack. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.init.create_multiple(
                ctx,
                instance_names=value,
                availability_zone=value,
                blueprint_id=value,
                bundle_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.init.create_multiple instance_names=value, availability_zone=value, blueprint_id=value, bundle_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_instances",
        op_kwargs={
            "instanceNames": instance_names,
            "availabilityZone": availability_zone,
            "customImageName": custom_image_name,
            "blueprintId": blueprint_id,
            "bundleId": bundle_id,
            "userData": user_data,
            "keyPairName": key_pair_name,
            "tags": tags,
            "addOns": add_ons,
            "ipAddressType": ip_address_type,
        },
    )


async def delete(
    hub, ctx, instance_name: str, force_delete_add_ons: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Amazon Lightsail instance. The delete instance operation supports tag-based access control via resource tags applied to the resource identified by instance name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        instance_name(str): The name of the instance to delete.
        force_delete_add_ons(bool, optional): A Boolean value to indicate whether to delete the enabled add-ons for the disk. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.init.delete(ctx, instance_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.init.delete instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_instance",
        op_kwargs={
            "instanceName": instance_name,
            "forceDeleteAddOns": force_delete_add_ons,
        },
    )


async def get(hub, ctx, instance_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific Amazon Lightsail instance, which is a virtual private server.

    Args:
        instance_name(str): The name of the instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.init.get(ctx, instance_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.init.get instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_instance",
        op_kwargs={"instanceName": instance_name},
    )


async def get_all(hub, ctx, page_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all Amazon Lightsail virtual private servers, or instances.

    Args:
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetInstances request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_instances",
        op_kwargs={"pageToken": page_token},
    )


async def reboot(hub, ctx, instance_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Restarts a specific instance. The reboot instance operation supports tag-based access control via resource tags applied to the resource identified by instance name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        instance_name(str): The name of the instance to reboot.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.init.reboot(ctx, instance_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.init.reboot instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="reboot_instance",
        op_kwargs={"instanceName": instance_name},
    )


async def start(hub, ctx, instance_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the reboot instance operation.  When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP address after stopping and starting an instance, create a static IP address and attach it to the instance. For more information, see the Amazon Lightsail Developer Guide.  The start instance operation supports tag-based access control via resource tags applied to the resource identified by instance name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        instance_name(str): The name of the instance (a virtual private server) to start.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.init.start(ctx, instance_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.init.start instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="start_instance",
        op_kwargs={"instanceName": instance_name},
    )


async def stop(hub, ctx, instance_name: str, force: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Stops a specific Amazon Lightsail instance that is currently running.  When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP address after stopping and starting an instance, create a static IP address and attach it to the instance. For more information, see the Amazon Lightsail Developer Guide.  The stop instance operation supports tag-based access control via resource tags applied to the resource identified by instance name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        instance_name(str): The name of the instance (a virtual private server) to stop.
        force(bool, optional): When set to True, forces a Lightsail instance that is stuck in a stopping state to stop.  Only use the force parameter if your instance is stuck in the stopping state. In any other state, your instance should stop normally without adding this parameter to your API request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.init.stop(ctx, instance_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.init.stop instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="stop_instance",
        op_kwargs={"instanceName": instance_name, "force": force},
    )
