"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    instance_names: List,
    availability_zone: str,
    bundle_id: str,
    attached_disk_mapping: Dict = None,
    instance_snapshot_name: str = None,
    user_data: str = None,
    key_pair_name: str = None,
    tags: List = None,
    add_ons: List = None,
    ip_address_type: str = None,
    source_instance_name: str = None,
    restore_date: str = None,
    use_latest_restorable_auto_snapshot: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates one or more new instances from a manual or automatic snapshot of an instance. The create instances from snapshot operation supports tag-based access control via request tags and resource tags applied to the resource identified by instance snapshot name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        instance_names(List): The names for your new instances.
        attached_disk_mapping(Dict, optional): An object containing information about one or more disk mappings. Defaults to None.
        availability_zone(str): The Availability Zone where you want to create your instances. Use the following formatting: us-east-2a (case sensitive). You can get a list of Availability Zones by using the get regions operation. Be sure to add the include Availability Zones parameter to your request.
        instance_snapshot_name(str, optional): The name of the instance snapshot on which you are basing your new instances. Use the get instance snapshots operation to return information about your existing snapshots. Constraint:   This parameter cannot be defined together with the source instance name parameter. The instance snapshot name and source instance name parameters are mutually exclusive.  . Defaults to None.
        bundle_id(str): The bundle of specification information for your virtual private server (or instance), including the pricing plan (e.g., micro_1_0).
        user_data(str, optional): You can create a launch script that configures a server with additional user data. For example, apt-get -y update.  Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use yum, Debian and Ubuntu use apt-get, and FreeBSD uses pkg. For a complete list, see the Amazon Lightsail Developer Guide. . Defaults to None.
        key_pair_name(str, optional): The name for your key pair. Defaults to None.
        tags(List, optional): The tag keys and optional values to add to the resource during create. Use the TagResource action to tag a resource after it's created. Defaults to None.
        add_ons(List, optional): An array of objects representing the add-ons to enable for the new instance. Defaults to None.
        ip_address_type(str, optional): The IP address type for the instance. The possible values are ipv4 for IPv4 only, and dualstack for IPv4 and IPv6. The default value is dualstack. Defaults to None.
        source_instance_name(str, optional): The name of the source instance from which the source automatic snapshot was created. Constraints:   This parameter cannot be defined together with the instance snapshot name parameter. The source instance name and instance snapshot name parameters are mutually exclusive.   Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the Amazon Lightsail Developer Guide.  . Defaults to None.
        restore_date(str, optional): The date of the automatic snapshot to use for the new instance. Use the get auto snapshots operation to identify the dates of the available automatic snapshots. Constraints:   Must be specified in YYYY-MM-DD format.   This parameter cannot be defined together with the use latest restorable auto snapshot parameter. The restore date and use latest restorable auto snapshot parameters are mutually exclusive.   Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the Amazon Lightsail Developer Guide.  . Defaults to None.
        use_latest_restorable_auto_snapshot(bool, optional): A Boolean value to indicate whether to use the latest available automatic snapshot. Constraints:   This parameter cannot be defined together with the restore date parameter. The use latest restorable auto snapshot and restore date parameters are mutually exclusive.   Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the Amazon Lightsail Developer Guide.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.from_.snapshot.create(
                ctx, instance_names=value, availability_zone=value, bundle_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.from_.snapshot.create instance_names=value, availability_zone=value, bundle_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_instances_from_snapshot",
        op_kwargs={
            "instanceNames": instance_names,
            "attachedDiskMapping": attached_disk_mapping,
            "availabilityZone": availability_zone,
            "instanceSnapshotName": instance_snapshot_name,
            "bundleId": bundle_id,
            "userData": user_data,
            "keyPairName": key_pair_name,
            "tags": tags,
            "addOns": add_ons,
            "ipAddressType": ip_address_type,
            "sourceInstanceName": source_instance_name,
            "restoreDate": restore_date,
            "useLatestRestorableAutoSnapshot": use_latest_restorable_auto_snapshot,
        },
    )
