"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def detach(hub, ctx, load_balancer_name: str, instance_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Detaches the specified instances from a Lightsail load balancer. This operation waits until the instances are no longer needed before they are detached from the load balancer. The detach instances from load balancer operation supports tag-based access control via resource tags applied to the resource identified by load balancer name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        load_balancer_name(str): The name of the Lightsail load balancer.
        instance_names(List): An array of strings containing the names of the instances you want to detach from the load balancer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.from_.load_balancer.detach(
                ctx, load_balancer_name=value, instance_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.from_.load_balancer.detach load_balancer_name=value, instance_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="detach_instances_from_load_balancer",
        op_kwargs={
            "loadBalancerName": load_balancer_name,
            "instanceNames": instance_names,
        },
    )
