"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, instance_name: str, protocol: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns temporary SSH keys you can use to connect to a specific virtual private server, or instance. The get instance access details operation supports tag-based access control via resource tags applied to the resource identified by instance name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        instance_name(str): The name of the instance to access.
        protocol(str, optional): The protocol to use to connect to your instance. Defaults to ssh. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.instance.access_detail.get_all(
                ctx, instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.instance.access_detail.get_all instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_instance_access_details",
        op_kwargs={"instanceName": instance_name, "protocol": protocol},
    )
