"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, domain_name: str, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a domain resource for the specified domain (e.g., example.com). The create domain operation supports tag-based access control via request tags. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        domain_name(str): The domain name to manage (e.g., example.com).  You cannot register a new domain name using Lightsail. You must register a domain name using Amazon Route 53 or another domain name registrar. If you have already registered your domain, you can enter its name in this parameter to manage the DNS records for that domain using Lightsail. .
        tags(List, optional): The tag keys and optional values to add to the resource during create. Use the TagResource action to tag a resource after it's created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.domain.init.create(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.domain.init.create domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_domain",
        op_kwargs={"domainName": domain_name, "tags": tags},
    )


async def delete(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified domain recordset and all of its domain records. The delete domain operation supports tag-based access control via resource tags applied to the resource identified by domain name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        domain_name(str): The specific domain name to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.domain.init.delete(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.domain.init.delete domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_domain",
        op_kwargs={"domainName": domain_name},
    )


async def get(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific domain recordset.

    Args:
        domain_name(str): The domain name for which your want to return information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.domain.init.get(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.domain.init.get domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_domain",
        op_kwargs={"domainName": domain_name},
    )


async def get_all(hub, ctx, page_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all domains in the user's account.

    Args:
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetDomains request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.domain.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.domain.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_domains",
        op_kwargs={"pageToken": page_token},
    )
