"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, domain_name: str, domain_entry: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates one of the following domain name system (DNS) records in a domain DNS zone: Address (A), canonical name (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT). The create domain entry operation supports tag-based access control via resource tags applied to the resource identified by domain name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        domain_name(str): The domain name (e.g., example.com) for which you want to create the domain entry.
        domain_entry(Dict): An array of key-value pairs containing information about the domain entry request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.domain.entry.create(
                ctx, domain_name=value, domain_entry=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.domain.entry.create domain_name=value, domain_entry=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_domain_entry",
        op_kwargs={"domainName": domain_name, "domainEntry": domain_entry},
    )


async def delete(hub, ctx, domain_name: str, domain_entry: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specific domain entry. The delete domain entry operation supports tag-based access control via resource tags applied to the resource identified by domain name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        domain_name(str): The name of the domain entry to delete.
        domain_entry(Dict): An array of key-value pairs containing information about your domain entries.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.domain.entry.delete(
                ctx, domain_name=value, domain_entry=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.domain.entry.delete domain_name=value, domain_entry=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_domain_entry",
        op_kwargs={"domainName": domain_name, "domainEntry": domain_entry},
    )


async def update(hub, ctx, domain_name: str, domain_entry: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates a domain recordset after it is created. The update domain entry operation supports tag-based access control via resource tags applied to the resource identified by domain name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        domain_name(str): The name of the domain recordset to update.
        domain_entry(Dict): An array of key-value pairs containing information about the domain entry.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.domain.entry.update(
                ctx, domain_name=value, domain_entry=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.domain.entry.update domain_name=value, domain_entry=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="update_domain_entry",
        op_kwargs={"domainName": domain_name, "domainEntry": domain_entry},
    )
