"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, distribution_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the timestamp and status of the last cache reset of a specific Amazon Lightsail content delivery network (CDN) distribution.

    Args:
        distribution_name(str, optional): The name of the distribution for which to return the timestamp of the last cache reset. Use the GetDistributions action to get a list of distribution names that you can specify. When omitted, the response includes the latest cache reset timestamp of all your distributions. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.distribution.latest_cache_reset.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.distribution.latest_cache_reset.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_distribution_latest_cache_reset",
        op_kwargs={"distributionName": distribution_name},
    )
