"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    distribution_name: str,
    origin: Dict,
    default_cache_behavior: Dict,
    bundle_id: str,
    cache_behavior_settings: Dict = None,
    cache_behaviors: List = None,
    ip_address_type: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon Lightsail content delivery network (CDN) distribution. A distribution is a globally distributed network of caching servers that improve the performance of your website or web application hosted on a Lightsail instance. For more information, see Content delivery networks in Amazon Lightsail.

    Args:
        distribution_name(str): The name for the distribution.
        origin(Dict): An object that describes the origin resource for the distribution, such as a Lightsail instance or load balancer. The distribution pulls, caches, and serves content from the origin.
        default_cache_behavior(Dict): An object that describes the default cache behavior for the distribution.
        cache_behavior_settings(Dict, optional): An object that describes the cache behavior settings for the distribution. Defaults to None.
        cache_behaviors(List, optional): An array of objects that describe the per-path cache behavior for the distribution. Defaults to None.
        bundle_id(str): The bundle ID to use for the distribution. A distribution bundle describes the specifications of your distribution, such as the monthly cost and monthly network transfer quota. Use the GetDistributionBundles action to get a list of distribution bundle IDs that you can specify.
        ip_address_type(str, optional): The IP address type for the distribution. The possible values are ipv4 for IPv4 only, and dualstack for IPv4 and IPv6. The default value is dualstack. Defaults to None.
        tags(List, optional): The tag keys and optional values to add to the distribution during create. Use the TagResource action to tag a resource after it's created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.distribution.init.create(
                ctx,
                distribution_name=value,
                origin=value,
                default_cache_behavior=value,
                bundle_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.distribution.init.create distribution_name=value, origin=value, default_cache_behavior=value, bundle_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_distribution",
        op_kwargs={
            "distributionName": distribution_name,
            "origin": origin,
            "defaultCacheBehavior": default_cache_behavior,
            "cacheBehaviorSettings": cache_behavior_settings,
            "cacheBehaviors": cache_behaviors,
            "bundleId": bundle_id,
            "ipAddressType": ip_address_type,
            "tags": tags,
        },
    )


async def delete(hub, ctx, distribution_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes your Amazon Lightsail content delivery network (CDN) distribution.

    Args:
        distribution_name(str, optional): The name of the distribution to delete. Use the GetDistributions action to get a list of distribution names that you can specify. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.distribution.init.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.distribution.init.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_distribution",
        op_kwargs={"distributionName": distribution_name},
    )


async def get_all(
    hub, ctx, distribution_name: str = None, page_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about one or more of your Amazon Lightsail content delivery network (CDN) distributions.

    Args:
        distribution_name(str, optional): The name of the distribution for which to return information. When omitted, the response includes all of your distributions in the AWS Region where the request is made. Defaults to None.
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetDistributions request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.distribution.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.distribution.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_distributions",
        op_kwargs={"distributionName": distribution_name, "pageToken": page_token},
    )


async def update(
    hub,
    ctx,
    distribution_name: str,
    origin: Dict = None,
    default_cache_behavior: Dict = None,
    cache_behavior_settings: Dict = None,
    cache_behaviors: List = None,
    is_enabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing Amazon Lightsail content delivery network (CDN) distribution. Use this action to update the configuration of your existing distribution.

    Args:
        distribution_name(str): The name of the distribution to update. Use the GetDistributions action to get a list of distribution names that you can specify.
        origin(Dict, optional): An object that describes the origin resource for the distribution, such as a Lightsail instance or load balancer. The distribution pulls, caches, and serves content from the origin. Defaults to None.
        default_cache_behavior(Dict, optional): An object that describes the default cache behavior for the distribution. Defaults to None.
        cache_behavior_settings(Dict, optional): An object that describes the cache behavior settings for the distribution.  The cacheBehaviorSettings specified in your UpdateDistributionRequest will replace your distribution's existing settings. . Defaults to None.
        cache_behaviors(List, optional): An array of objects that describe the per-path cache behavior for the distribution. Defaults to None.
        is_enabled(bool, optional): Indicates whether to enable the distribution. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.distribution.init.update(ctx, distribution_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.distribution.init.update distribution_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="update_distribution",
        op_kwargs={
            "distributionName": distribution_name,
            "origin": origin,
            "defaultCacheBehavior": default_cache_behavior,
            "cacheBehaviorSettings": cache_behavior_settings,
            "cacheBehaviors": cache_behaviors,
            "isEnabled": is_enabled,
        },
    )
