"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def reset(hub, ctx, distribution_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes currently cached content from your Amazon Lightsail content delivery network (CDN) distribution. After resetting the cache, the next time a content request is made, your distribution pulls, serves, and caches it from the origin.

    Args:
        distribution_name(str, optional): The name of the distribution for which to reset cache. Use the GetDistributions action to get a list of distribution names that you can specify. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.distribution.cache.reset(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.distribution.cache.reset
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="reset_distribution_cache",
        op_kwargs={"distributionName": distribution_name},
    )
