"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns the bundles that can be applied to your Amazon Lightsail content delivery network (CDN) distributions. A distribution bundle specifies the monthly network transfer quota and monthly cost of your dsitribution.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.distribution.bundle.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.distribution.bundle.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_distribution_bundles",
        op_kwargs={},
    )


async def update(
    hub, ctx, distribution_name: str = None, bundle_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the bundle of your Amazon Lightsail content delivery network (CDN) distribution. A distribution bundle specifies the monthly network transfer quota and monthly cost of your dsitribution. Update your distribution's bundle if your distribution is going over its monthly network transfer quota and is incurring an overage fee. You can update your distribution's bundle only one time within your monthly AWS billing cycle. To determine if you can update your distribution's bundle, use the GetDistributions action. The ableToUpdateBundle parameter in the result will indicate whether you can currently update your distribution's bundle.

    Args:
        distribution_name(str, optional): The name of the distribution for which to update the bundle. Use the GetDistributions action to get a list of distribution names that you can specify. Defaults to None.
        bundle_id(str, optional): The bundle ID of the new bundle to apply to your distribution. Use the GetDistributionBundles action to get a list of distribution bundle IDs that you can specify. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.distribution.bundle.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.distribution.bundle.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="update_distribution_bundle",
        op_kwargs={"distributionName": distribution_name, "bundleId": bundle_id},
    )
