"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    disk_snapshot_name: str,
    disk_name: str = None,
    instance_name: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a snapshot of a block storage disk. You can use snapshots for backups, to make copies of disks, and to save data before shutting down a Lightsail instance. You can take a snapshot of an attached disk that is in use; however, snapshots only capture data that has been written to your disk at the time the snapshot command is issued. This may exclude any data that has been cached by any applications or the operating system. If you can pause any file systems on the disk long enough to take a snapshot, your snapshot should be complete. Nevertheless, if you cannot pause all file writes to the disk, you should unmount the disk from within the Lightsail instance, issue the create disk snapshot command, and then remount the disk to ensure a consistent and complete snapshot. You may remount and use your disk while the snapshot status is pending. You can also use this operation to create a snapshot of an instance's system volume. You might want to do this, for example, to recover data from the system volume of a botched instance or to create a backup of the system volume like you would for a block storage disk. To create a snapshot of a system volume, just define the instance name parameter when issuing the snapshot command, and a snapshot of the defined instance's system volume will be created. After the snapshot is available, you can create a block storage disk from the snapshot and attach it to a running instance to access the data on the disk. The create disk snapshot operation supports tag-based access control via request tags. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        disk_name(str, optional): The unique name of the source disk (e.g., Disk-Virginia-1).  This parameter cannot be defined together with the instance name parameter. The disk name and instance name parameters are mutually exclusive. . Defaults to None.
        disk_snapshot_name(str): The name of the destination disk snapshot (e.g., my-disk-snapshot) based on the source disk.
        instance_name(str, optional): The unique name of the source instance (e.g., Amazon_Linux-512MB-Virginia-1). When this is defined, a snapshot of the instance's system volume is created.  This parameter cannot be defined together with the disk name parameter. The instance name and disk name parameters are mutually exclusive. . Defaults to None.
        tags(List, optional): The tag keys and optional values to add to the resource during create. Use the TagResource action to tag a resource after it's created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.disk.snapshot.create(ctx, disk_snapshot_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.disk.snapshot.create disk_snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_disk_snapshot",
        op_kwargs={
            "diskName": disk_name,
            "diskSnapshotName": disk_snapshot_name,
            "instanceName": instance_name,
            "tags": tags,
        },
    )


async def delete(hub, ctx, disk_snapshot_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified disk snapshot. When you make periodic snapshots of a disk, the snapshots are incremental, and only the blocks on the device that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all active snapshots will have access to all the information needed to restore the disk. The delete disk snapshot operation supports tag-based access control via resource tags applied to the resource identified by disk snapshot name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        disk_snapshot_name(str): The name of the disk snapshot you want to delete (e.g., my-disk-snapshot).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.disk.snapshot.delete(ctx, disk_snapshot_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.disk.snapshot.delete disk_snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_disk_snapshot",
        op_kwargs={"diskSnapshotName": disk_snapshot_name},
    )


async def get(hub, ctx, disk_snapshot_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific block storage disk snapshot.

    Args:
        disk_snapshot_name(str): The name of the disk snapshot (e.g., my-disk-snapshot).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.disk.snapshot.get(ctx, disk_snapshot_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.disk.snapshot.get disk_snapshot_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_disk_snapshot",
        op_kwargs={"diskSnapshotName": disk_snapshot_name},
    )


async def get_all(hub, ctx, page_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all block storage disk snapshots in your AWS account and region.

    Args:
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetDiskSnapshots request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.disk.snapshot.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.disk.snapshot.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_disk_snapshots",
        op_kwargs={"pageToken": page_token},
    )
