"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(hub, ctx, disk_name: str, instance_name: str, disk_path: str) -> Dict:
    r"""
    **Autogenerated function**

    Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the specified disk name. The attach disk operation supports tag-based access control via resource tags applied to the resource identified by disk name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        disk_name(str): The unique Lightsail disk name (e.g., my-disk).
        instance_name(str): The name of the Lightsail instance where you want to utilize the storage disk.
        disk_path(str): The disk path to expose to the instance (e.g., /dev/xvdf).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.disk.init.attach(
                ctx, disk_name=value, instance_name=value, disk_path=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.disk.init.attach disk_name=value, instance_name=value, disk_path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="attach_disk",
        op_kwargs={
            "diskName": disk_name,
            "instanceName": instance_name,
            "diskPath": disk_path,
        },
    )


async def create(
    hub,
    ctx,
    disk_name: str,
    availability_zone: str,
    size_in_gb: int,
    tags: List = None,
    add_ons: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a block storage disk that can be attached to an Amazon Lightsail instance in the same Availability Zone (e.g., us-east-2a). The create disk operation supports tag-based access control via request tags. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        disk_name(str): The unique Lightsail disk name (e.g., my-disk).
        availability_zone(str): The Availability Zone where you want to create the disk (e.g., us-east-2a). Use the same Availability Zone as the Lightsail instance to which you want to attach the disk. Use the get regions operation to list the Availability Zones where Lightsail is currently available.
        size_in_gb(int): The size of the disk in GB (e.g., 32).
        tags(List, optional): The tag keys and optional values to add to the resource during create. Use the TagResource action to tag a resource after it's created. Defaults to None.
        add_ons(List, optional): An array of objects that represent the add-ons to enable for the new disk. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.disk.init.create(
                ctx, disk_name=value, availability_zone=value, size_in_gb=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.disk.init.create disk_name=value, availability_zone=value, size_in_gb=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_disk",
        op_kwargs={
            "diskName": disk_name,
            "availabilityZone": availability_zone,
            "sizeInGb": size_in_gb,
            "tags": tags,
            "addOns": add_ons,
        },
    )


async def delete(hub, ctx, disk_name: str, force_delete_add_ons: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified block storage disk. The disk must be in the available state (not attached to a Lightsail instance).  The disk may remain in the deleting state for several minutes.  The delete disk operation supports tag-based access control via resource tags applied to the resource identified by disk name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        disk_name(str): The unique name of the disk you want to delete (e.g., my-disk).
        force_delete_add_ons(bool, optional): A Boolean value to indicate whether to delete the enabled add-ons for the disk. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.disk.init.delete(ctx, disk_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.disk.init.delete disk_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="delete_disk",
        op_kwargs={"diskName": disk_name, "forceDeleteAddOns": force_delete_add_ons},
    )


async def detach(hub, ctx, disk_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any file systems on the device within your operating system before stopping the instance and detaching the disk. The detach disk operation supports tag-based access control via resource tags applied to the resource identified by disk name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        disk_name(str): The unique name of the disk you want to detach from your instance (e.g., my-disk).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.disk.init.detach(ctx, disk_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.disk.init.detach disk_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="detach_disk",
        op_kwargs={"diskName": disk_name},
    )


async def get(hub, ctx, disk_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific block storage disk.

    Args:
        disk_name(str): The name of the disk (e.g., my-disk).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.disk.init.get(ctx, disk_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.disk.init.get disk_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_disk",
        op_kwargs={"diskName": disk_name},
    )


async def get_all(hub, ctx, page_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all block storage disks in your AWS account and region.

    Args:
        page_token(str, optional): The token to advance to the next page of results from your request. To get a page token, perform an initial GetDisks request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.disk.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.disk.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_disks",
        op_kwargs={"pageToken": page_token},
    )
