"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    disk_name: str,
    availability_zone: str,
    size_in_gb: int,
    disk_snapshot_name: str = None,
    tags: List = None,
    add_ons: List = None,
    source_disk_name: str = None,
    restore_date: str = None,
    use_latest_restorable_auto_snapshot: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a block storage disk from a manual or automatic snapshot of a disk. The resulting disk can be attached to an Amazon Lightsail instance in the same Availability Zone (e.g., us-east-2a). The create disk from snapshot operation supports tag-based access control via request tags and resource tags applied to the resource identified by disk snapshot name. For more information, see the Amazon Lightsail Developer Guide.

    Args:
        disk_name(str): The unique Lightsail disk name (e.g., my-disk).
        disk_snapshot_name(str, optional): The name of the disk snapshot (e.g., my-snapshot) from which to create the new storage disk. Constraint:   This parameter cannot be defined together with the source disk name parameter. The disk snapshot name and source disk name parameters are mutually exclusive.  . Defaults to None.
        availability_zone(str): The Availability Zone where you want to create the disk (e.g., us-east-2a). Choose the same Availability Zone as the Lightsail instance where you want to create the disk. Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
        size_in_gb(int): The size of the disk in GB (e.g., 32).
        tags(List, optional): The tag keys and optional values to add to the resource during create. Use the TagResource action to tag a resource after it's created. Defaults to None.
        add_ons(List, optional): An array of objects that represent the add-ons to enable for the new disk. Defaults to None.
        source_disk_name(str, optional): The name of the source disk from which the source automatic snapshot was created. Constraints:   This parameter cannot be defined together with the disk snapshot name parameter. The source disk name and disk snapshot name parameters are mutually exclusive.   Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the Amazon Lightsail Developer Guide.  . Defaults to None.
        restore_date(str, optional): The date of the automatic snapshot to use for the new disk. Use the get auto snapshots operation to identify the dates of the available automatic snapshots. Constraints:   Must be specified in YYYY-MM-DD format.   This parameter cannot be defined together with the use latest restorable auto snapshot parameter. The restore date and use latest restorable auto snapshot parameters are mutually exclusive.   Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the Amazon Lightsail Developer Guide.  . Defaults to None.
        use_latest_restorable_auto_snapshot(bool, optional): A Boolean value to indicate whether to use the latest available automatic snapshot. Constraints:   This parameter cannot be defined together with the restore date parameter. The use latest restorable auto snapshot and restore date parameters are mutually exclusive.   Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the Amazon Lightsail Developer Guide.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.disk.from_snapshot.create(
                ctx, disk_name=value, availability_zone=value, size_in_gb=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.disk.from_snapshot.create disk_name=value, availability_zone=value, size_in_gb=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="create_disk_from_snapshot",
        op_kwargs={
            "diskName": disk_name,
            "diskSnapshotName": disk_snapshot_name,
            "availabilityZone": availability_zone,
            "sizeInGb": size_in_gb,
            "tags": tags,
            "addOns": add_ons,
            "sourceDiskName": source_disk_name,
            "restoreDate": restore_date,
            "useLatestRestorableAutoSnapshot": use_latest_restorable_auto_snapshot,
        },
    )
