"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def download(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Downloads the default SSH key pair from the user's account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.default_key_pair.download(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.default_key_pair.download
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="download_default_key_pair",
        op_kwargs={},
    )
