"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of powers that can be specified for your Amazon Lightsail container services. The power specifies the amount of memory, the number of vCPUs, and the base price of the container service.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.container.service.power.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.container.service.power.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_container_service_powers",
        op_kwargs={},
    )
