"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    service_name: str,
    metric_name: str,
    start_time: str,
    end_time: str,
    period: int,
    statistics: List,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the data points of a specific metric of your Amazon Lightsail container service. Metrics report the utilization of your resources. Monitor and collect metric data regularly to maintain the reliability, availability, and performance of your resources.

    Args:
        service_name(str): The name of the container service for which to get metric data.
        metric_name(str): The metric for which you want to return information. Valid container service metric names are listed below, along with the most useful statistics to include in your request, and the published unit value.    CPUUtilization - The average percentage of compute units that are currently in use across all nodes of the container service. This metric identifies the processing power required to run containers on each node of the container service. Statistics: The most useful statistics are Maximum and Average. Unit: The published unit is Percent.    MemoryUtilization - The average percentage of available memory that is currently in use across all nodes of the container service. This metric identifies the memory required to run containers on each node of the container service. Statistics: The most useful statistics are Maximum and Average. Unit: The published unit is Percent.  .
        start_time(str): The start time of the time period.
        end_time(str): The end time of the time period.
        period(int): The granularity, in seconds, of the returned data points. All container service metric data is available in 5-minute (300 seconds) granularity.
        statistics(List): The statistic for the metric. The following statistics are available:    Minimum - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.    Maximum - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.    Sum - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.    Average - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.    SampleCount - The count, or number, of data points used for the statistical calculation.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.lightsail.container.service.metric_data.get(
                ctx,
                service_name=value,
                metric_name=value,
                start_time=value,
                end_time=value,
                period=value,
                statistics=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.lightsail.container.service.metric_data.get service_name=value, metric_name=value, start_time=value, end_time=value, period=value, statistics=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="lightsail",
        operation="get_container_service_metric_data",
        op_kwargs={
            "serviceName": service_name,
            "metricName": metric_name,
            "startTime": start_time,
            "endTime": end_time,
            "period": period,
            "statistics": statistics,
        },
    )
